﻿#pragma once

class CLogDialog :
  public CDialogImpl<CLogDialog>
{
private:
  szstring logText;

public:
  enum { IDD = IDD_LOG };

  CLogDialog(const szstring & logText) : logText(logText)
  {
  }

  BEGIN_MSG_MAP(CLogDialog)
    MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
    COMMAND_ID_HANDLER(IDOK, OnOK)
  END_MSG_MAP()

  LRESULT OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL &bHandled)
  {
    CenterWindow();

    HICON hIcon = (HICON)::LoadImage(theModule.GetResourceInstance(), MAKEINTRESOURCE(IDR_MAINFRAME), 
      IMAGE_ICON, ::GetSystemMetrics(SM_CXICON), ::GetSystemMetrics(SM_CYICON), LR_DEFAULTCOLOR);
    SetIcon(hIcon, TRUE);
    HICON hIconSmall = (HICON)::LoadImage(theModule.GetResourceInstance(), MAKEINTRESOURCE(IDR_MAINFRAME), 
      IMAGE_ICON, ::GetSystemMetrics(SM_CXSMICON), ::GetSystemMetrics(SM_CYSMICON), LR_DEFAULTCOLOR);
    SetIcon(hIconSmall, FALSE);

    SetWindowText(SZT("Log"));
    SetDlgItemText(IDC_EDIT_LOG, logText.c_str());

    return TRUE;
  }

  LRESULT OnOK(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL &bHandled)
  {
    EndDialog(wID);
    return 0;
  }
};
